import csv


def read_csv_repos(file):
    input_csv = open('{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1], 'base': r[8]} for r in reader_csv]
    input_csv.close()
    return repos

def read_csv_months(file):
    input_csv = open('data/{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1], 'bot': r[2], 'date_before': r[3], 'date_after': r[4], 'time': r[5], 'intervention': r[6], 'time_after_intervention': r[7]} for r in reader_csv]
    input_csv.close()
    return repos

def read_csv_months_bot(file):
    input_csv = open('data/{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1], 'bot': r[2], 'date_before': r[3], 'date_after': r[4], 'time': r[5], 'intervention': r[6], 'time_after_intervention': r[7], 'merged': r[8], 'nonmerged': r[9], 'lang': r[10], 'total_number_pr_authors': r[11], 'commits': r[12], 'age_at_bot': r[13], 'index': r[14], 'name': r[15]} for r in reader_csv]
    input_csv.close()
    return repos


def read_csv_months_new(file):
    input_csv = open('data/{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1], 'bot': r[2], 'date_before': r[3], 'date_after': r[4], 'time': r[5], 'intervention': r[6], 'time_after_intervention': r[7], 'merged': r[8], 'nonmerged': r[9], 'lang': r[10], 'total_number_pr_authors': r[11], 'commits': r[12], 'age_at_bot': r[13], 'index': r[14], 'name': r[15], 'bot_comments': r[16]} for r in reader_csv]
    input_csv.close()
    return repos


def read_projects(file):
    input_csv = open('{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'bot': r[0], 'owner': r[2], 'repo': r[1]} for r in reader_csv]
    input_csv.close()
    return repos

def read_survey(file):
    input_csv = open('{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1], 'bot': r[2], 'adoption': r[16]} for r in reader_csv]
    input_csv.close()
    return repos

def read_project(file):
    input_csv = open('data/{}'.format(file), 'r')
    reader_csv = csv.reader(input_csv, delimiter=',')

    repos = [{'owner': r[0], 'repo': r[1]} for r in reader_csv]
    input_csv.close()
    return repos